package service;


public class SimpleStateImpl extends SimpleState {
	boolean isInitial, isFinal;
	/** Create a new state
	 * @param name the name that identifies the state
	 * @param isInitial this argument is true if the new state is an initial state
	 * @param isFinal  this argument is true if the new state is a final state
	 */
	public SimpleStateImpl(String name, boolean isInitial, boolean isFinal) {
		super(name, isInitial, isFinal);
		this.isInitial = isInitial;
		this.isFinal = isFinal;
	}

	/** Returns if the current state is final or not.
	 * @return returns true if the state is final else return false
	 */
	public boolean isFinal() {
		return isFinal;
	}
	/** Returns if the current state is a initial state.
	 * @return returns true if the state is a initials state else return false
	 */
	public boolean isInitial() {
		return isInitial;
	}
	/**
	 * This method returns the hashCode of the state
	 * @return The string contains the hashCode of the state
	 */
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + (isFinal ? 1231 : 1237);
		result = prime * result + (isInitial ? 1231 : 1237);
		return result;
	}

	/**
	 * This method compares a state with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a State and the attributes of the two State are equals.
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SimpleStateImpl other = (SimpleStateImpl) obj;
		if (isFinal != other.isFinal)
			return false;
		if (isInitial != other.isInitial)
			return false;
		return true;
	}
	/** Set the property "final" of the state
	 * @param finalstate finalstate is true if we want set the state as a final state else this argument is false 
	 */
	public void setFinal(boolean finalstate) {
		isFinal=finalstate;		
	}
	/** Set the property "initial" of the state
	 * @param initialstate initialstate is true if we want set the state as an initial state else this argument is false 
	 */
	public void setInitial(boolean initialstate) {
		isInitial=initialstate;
	}
}
